/* --------------------------------------------------------------
 delete_old_emails_modal.js 2018-06-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2018 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 ----------------------------------------------------------------
 */

/**
 * ## Attachments Modal Controller
 *
 * This controller will handle the attachments modal dialog operations of the admin/emails page.
 *
 * @module Controllers/attachments_modal
 */
gx.controllers.module(
    'delete_old_emails_modal',

    [
        'modal',
        gx.source + '/libs/emails'
    ],

    /** @lends module:Controllers/attachments_modal */

    function (data) {

        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLE DEFINITION
        // ------------------------------------------------------------------------

        /**
         * Module Reference
         *
         * @type {object}
         */
        const $this = $(this);

        /**
         * Emails Main Table Selector
         *
         * @type {object}
         */
        const $table = $('#emails-table');

        /**
         * Default Module Options
         *
         * @type {object}
         */
        const defaults = {};

        /**
         * Final Module Options
         *
         * @type {object}
         */
        const options = $.extend(true, {}, defaults, data);

        /**
         * Module Object
         *
         * @type {object}
         */
        const module = {};

        // ------------------------------------------------------------------------
        // EVENT HANDLERS
        // ------------------------------------------------------------------------

        /**
         * Delete old emails request.
         *
         * @param {object} event Contains the event information.
         */
        const _onDeleteOldEmails = function (event) {
            // Validate selected date before making the request.
            if ($this.find('#email-removal-date').val() === '') {
                return; // do not proceed
            }

            // Display confirmation modal before proceeding.
            const removalDate = $this.find('#email-removal-date').datepicker('getDate').toString('yyyy-MM-dd');

            const modalOptions = {
                title: jse.core.lang.translate('delete', 'buttons') + ' - ' + removalDate,
                content: jse.core.lang.translate('prompt_delete_old_emails', 'emails'),
                buttons: [
                    {
                        text: jse.core.lang.translate('no', 'lightbox_buttons'),
                        click: function () {
                            $(this).dialog('close');
                        }
                    },
                    {
                        text: jse.core.lang.translate('yes', 'lightbox_buttons'),
                        click: function () {
                            jse.libs.emails.deleteOldEmails(removalDate)
                                .done(function (response) {
                                    const message =
                                        jse.core.lang.translate('message_delete_old_emails_success', 'emails');

                                    jse.libs.modal.message({
                                        title: 'Info',
                                        content: message
                                    });

                                    $table.DataTable().ajax.reload();
                                    $this.dialog('close');
                                })
                                .fail(function (response) {
                                    const title = jse.core.lang.translate('error', 'messages');

                                    jse.libs.modal.message({
                                        title: title,
                                        content: response.message
                                    });
                                });

                            $(this).dialog('close');
                        }
                    }
                ]
            };

            jse.libs.modal.message(modalOptions);
        };

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------

        /**
         * Initialize method of the module, called by the engine.
         */
        module.init = function (done) {
            $this.on('click', '#delete-old-emails', _onDeleteOldEmails);
            done();
        };

        return module;
    });
